/**
 * 
 */
package gov.va.genisis2.dao;

import java.util.List;

import gov.va.genisis2.exceptions.GenisisDAOException;
import gov.va.genisis2.model.Request;
import gov.va.genisis2.model.RequestHistory;
import gov.va.genisis2.model.WorkflowStatus;

/**
 * @author 586338
 *
 */
public interface IRequestDao {
	public int createRequest(Request request) throws GenisisDAOException;

	public List<Request> getRequestsByUID(String uid) throws GenisisDAOException;

	public List<Request> getRequestsByDataManager(String uid) throws GenisisDAOException;

	public List<Request> getRequestsDataManagers(String uid) throws GenisisDAOException;

	public List<Request> getRequestsDataSourceManagers(String uid) throws GenisisDAOException;

	public Request getRequestById(int id) throws GenisisDAOException;

	public List<Request> getAllRequests()throws GenisisDAOException;

	public List<Request> getAllRequestsByStudyApproval(int studyApprovalId)throws GenisisDAOException;

	public List<Request> getAllRequestsByStaus(String status)throws GenisisDAOException;

	public int submitOrModify(Request request)throws GenisisDAOException;

	public int submitOrModify(RequestHistory requestHistory)throws GenisisDAOException;

	public List<RequestHistory> getRequestHistoriesById(int requestId)throws GenisisDAOException;

	public List<RequestHistory> getRequestHistoriesByRequestIdAndStatus(int requestId, String status)throws GenisisDAOException;
	
	public List<RequestHistory> getRequestHistoriesWithCommentsById(int requestId)throws GenisisDAOException;
	
	public List<WorkflowStatus> getRequestStatusCounts() throws GenisisDAOException;
	
	public WorkflowStatus getWorkflowStatus(String status) throws GenisisDAOException;
}
